<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Tables\Post\PostCommentTable;

final class PostCommentBuilder implements InterfacePostCommentSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitPostCommentSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            PostCommentTable::OWNER_USER_ID            => '',
            PostCommentTable::PARENT_POST_ID           => '',

            PostCommentTable::REPLY_TO_POST_COMMENT_ID => '0',

            PostCommentTable::DISPLAY_TEXT             => '',

            PostCommentTable::CACHE_LIKES_COUNT        => '0',
            PostCommentTable::CACHE_COMMENTS_COUNT     => '0',

            PostCommentTable::STAMP_REGISTRATION       => System::isoDateTime(),
            PostCommentTable::STAMP_LAST_UPDATE        => System::isoDateTime(),
        );
    }

    public function dispense(): PostCommentModel
    {
        return PostCommentModel::createFromData(
            array(
                // owner user id

                PostCommentTable::OWNER_USER_ID => $this -> ownerUserId

                ?? $this -> defaultValues[PostCommentTable::OWNER_USER_ID],

                // parent post id

                PostCommentTable::PARENT_POST_ID => $this -> parentPostId

                ?? $this -> defaultValues[PostCommentTable::PARENT_POST_ID],

                // reply to post comment id

                PostCommentTable::REPLY_TO_POST_COMMENT_ID => $this -> replyToPostCommentId

                ?? $this -> defaultValues[PostCommentTable::REPLY_TO_POST_COMMENT_ID],

                // display text

                PostCommentTable::DISPLAY_TEXT => $this -> displayText

                ?? $this -> defaultValues[PostCommentTable::DISPLAY_TEXT],

                // cache likes count

                PostCommentTable::CACHE_LIKES_COUNT => $this -> cacheLikesCount

                ?? $this -> defaultValues[PostCommentTable::CACHE_LIKES_COUNT],

                // cache comments count

                PostCommentTable::CACHE_COMMENTS_COUNT => $this -> cacheCommentsCount

                ?? $this -> defaultValues[PostCommentTable::CACHE_COMMENTS_COUNT],

                // stamp registration

                PostCommentTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[PostCommentTable::STAMP_REGISTRATION],

                // stamp last update

                PostCommentTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[PostCommentTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
